<?php
require 'includes/config.inc.php';

// Check if manager is logged in
if (!isset($_SESSION['username'])) {
    header("Location: login-hostel_manager.php");
    exit();
}

// Handle status update
if (isset($_POST['update-complaint'])) {
    $complaint_id = mysqli_real_escape_string($conn, $_POST['complaint_id']);
    $status = mysqli_real_escape_string($conn, $_POST['status']);
    $response = mysqli_real_escape_string($conn, $_POST['response']);
    
    $sql = "UPDATE complaints SET status = ?, response = ? WHERE complaint_id = ?";
    $stmt = mysqli_stmt_init($conn);
    if (mysqli_stmt_prepare($stmt, $sql)) {
        mysqli_stmt_bind_param($stmt, "ssi", $status, $response, $complaint_id);
        mysqli_stmt_execute($stmt);
    }
}

// Get filter
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';
$where_clause = $status_filter ? "WHERE status = '$status_filter'" : "";

// Get complaints statistics
$stats_sql = "SELECT 
    COUNT(*) as total,
    SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending,
    SUM(CASE WHEN status = 'in_progress' THEN 1 ELSE 0 END) as in_progress,
    SUM(CASE WHEN status = 'resolved' THEN 1 ELSE 0 END) as resolved,
    SUM(CASE WHEN status = 'rejected' THEN 1 ELSE 0 END) as rejected
    FROM complaints";
$stats_result = mysqli_query($conn, $stats_sql);
$stats = mysqli_fetch_assoc($stats_result);

// Get all complaints
$complaints_sql = "SELECT c.*, s.Fname, s.Lname, s.Mob_no, s.Dept 
                   FROM complaints c 
                   LEFT JOIN Student s ON c.student_id = s.Student_id 
                   $where_clause
                   ORDER BY 
                       CASE c.priority 
                           WHEN 'urgent' THEN 1 
                           WHEN 'high' THEN 2 
                           WHEN 'medium' THEN 3 
                           WHEN 'low' THEN 4 
                       END,
                       c.created_at DESC";
$complaints_result = mysqli_query($conn, $complaints_sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Manage Complaints - HMS Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta charset="utf-8">
    <link rel="stylesheet" href="web_home/css_home/bootstrap.css">
    <link rel="stylesheet" href="web_home/css_home/style.css" type="text/css" media="all" />
    <link rel="stylesheet" href="web_home/css_home/fontawesome-all.css">
    <link href="//fonts.googleapis.com/css?family=Poiret+One&amp;subset=cyrillic,latin-ext" rel="stylesheet">
    <style>
        .dashboard-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 15px;
            padding: 25px;
            color: white;
            margin-bottom: 20px;
            transition: all 0.3s ease;
        }
        .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(102, 126, 234, 0.4);
        }
        .dashboard-card.pending { background: linear-gradient(135deg, #ff9800 0%, #f57c00 100%); }
        .dashboard-card.in-progress { background: linear-gradient(135deg, #2196f3 0%, #1976d2 100%); }
        .dashboard-card.resolved { background: linear-gradient(135deg, #4caf50 0%, #388e3c 100%); }
        .dashboard-card.rejected { background: linear-gradient(135deg, #f44336 0%, #d32f2f 100%); }
        .dashboard-card h2 { font-size: 42px; margin: 0; font-weight: 700; }
        .dashboard-card p { margin: 5px 0 0; opacity: 0.9; }
        
        .complaint-table {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }
        .complaint-table thead {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            color: white;
        }
        .complaint-table th, .complaint-table td {
            padding: 15px;
            vertical-align: middle;
        }
        .complaint-table tbody tr {
            border-bottom: 1px solid #eee;
            transition: all 0.3s ease;
        }
        .complaint-table tbody tr:hover {
            background: #f8f9ff;
        }
        
        .status-badge {
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }
        .status-pending { background: #fff3e0; color: #ef6c00; }
        .status-in_progress { background: #e3f2fd; color: #1976d2; }
        .status-resolved { background: #e8f5e9; color: #388e3c; }
        .status-rejected { background: #ffebee; color: #c62828; }
        
        .priority-badge {
            padding: 3px 10px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 600;
        }
        .priority-low { background: #e8f5e9; color: #2e7d32; }
        .priority-medium { background: #fff3e0; color: #ef6c00; }
        .priority-high { background: #ffebee; color: #c62828; }
        .priority-urgent { background: #f44336; color: white; animation: pulse 1s infinite; }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }
        
        .btn-action {
            background: linear-gradient(135deg, #00d4ff 0%, #7c3aed 100%);
            border: none;
            padding: 8px 20px;
            border-radius: 20px;
            color: white;
            font-size: 12px;
            transition: all 0.3s ease;
        }
        .btn-action:hover {
            transform: scale(1.05);
            box-shadow: 0 5px 20px rgba(124, 58, 237, 0.4);
            color: white;
        }
        
        .modal-content {
            border-radius: 15px;
            border: none;
        }
        .modal-header {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            color: white;
            border-radius: 15px 15px 0 0;
        }
        
        .filter-btn {
            padding: 8px 20px;
            border-radius: 20px;
            margin: 5px;
            border: 2px solid #7c3aed;
            background: white;
            color: #7c3aed;
            transition: all 0.3s ease;
        }
        .filter-btn:hover, .filter-btn.active {
            background: #7c3aed;
            color: white;
        }
    </style>
</head>
<body>
    <div class="banner" id="home">
        <div class="cd-radial-slider-wrapper">
            <header>
                <div class="container agile-banner_nav">
                    <nav class="navbar navbar-expand-lg navbar-light bg-light">
                        <h1><a class="navbar-brand" href="<?php echo $_SESSION['isadmin'] ? 'admin/admin_home.php' : 'home_manager.php'; ?>">HMS <span class="display"></span></a></h1>
                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        <div class="collapse navbar-collapse justify-content-center" id="navbarSupportedContent">
                            <ul class="navbar-nav ml-auto">
                                <li class="nav-item"><a class="nav-link" href="<?php echo $_SESSION['isadmin'] ? 'admin/admin_home.php' : 'home_manager.php'; ?>">Home</a></li>
                                <li class="nav-item active"><a class="nav-link" href="manage_complaints.php">Complaints</a></li>
                                <li class="nav-item"><a class="nav-link" href="allocate_room.php">Allocate Room</a></li>
                                <li class="nav-item"><a class="nav-link" href="includes/logout.inc.php">Logout</a></li>
                            </ul>
                        </div>
                    </nav>
                </div>
            </header>
        </div>
    </div>

    <div class="container" style="padding-top: 30px;">
        <h2 style="color: #1a1a2e; margin-bottom: 30px;"><i class="fas fa-clipboard-list"></i> Complaint Management Dashboard</h2>
        
        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="dashboard-card">
                    <h2><?php echo $stats['total'] ?? 0; ?></h2>
                    <p><i class="fas fa-inbox"></i> Total Complaints</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="dashboard-card pending">
                    <h2><?php echo $stats['pending'] ?? 0; ?></h2>
                    <p><i class="fas fa-clock"></i> Pending</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="dashboard-card in-progress">
                    <h2><?php echo $stats['in_progress'] ?? 0; ?></h2>
                    <p><i class="fas fa-spinner"></i> In Progress</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="dashboard-card resolved">
                    <h2><?php echo $stats['resolved'] ?? 0; ?></h2>
                    <p><i class="fas fa-check-circle"></i> Resolved</p>
                </div>
            </div>
        </div>
        
        <!-- Filters -->
        <div class="mb-4 text-center">
            <a href="manage_complaints.php" class="filter-btn <?php echo !$status_filter ? 'active' : ''; ?>">All</a>
            <a href="manage_complaints.php?status=pending" class="filter-btn <?php echo $status_filter == 'pending' ? 'active' : ''; ?>">Pending</a>
            <a href="manage_complaints.php?status=in_progress" class="filter-btn <?php echo $status_filter == 'in_progress' ? 'active' : ''; ?>">In Progress</a>
            <a href="manage_complaints.php?status=resolved" class="filter-btn <?php echo $status_filter == 'resolved' ? 'active' : ''; ?>">Resolved</a>
            <a href="manage_complaints.php?status=rejected" class="filter-btn <?php echo $status_filter == 'rejected' ? 'active' : ''; ?>">Rejected</a>
        </div>
        
        <!-- Complaints Table -->
        <div class="complaint-table">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Student</th>
                        <th>Category</th>
                        <th>Subject</th>
                        <th>Priority</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (mysqli_num_rows($complaints_result) == 0): ?>
                        <tr><td colspan="8" class="text-center py-5">No complaints found.</td></tr>
                    <?php else: ?>
                        <?php while ($complaint = mysqli_fetch_assoc($complaints_result)): ?>
                            <tr>
                                <td><strong>#<?php echo $complaint['complaint_id']; ?></strong></td>
                                <td>
                                    <strong><?php echo htmlspecialchars($complaint['Fname'] . ' ' . $complaint['Lname']); ?></strong><br>
                                    <small class="text-muted"><?php echo htmlspecialchars($complaint['student_id']); ?></small>
                                </td>
                                <td><?php echo htmlspecialchars($complaint['category']); ?></td>
                                <td><?php echo htmlspecialchars(substr($complaint['subject'], 0, 30)); ?>...</td>
                                <td><span class="priority-badge priority-<?php echo $complaint['priority']; ?>"><?php echo ucfirst($complaint['priority']); ?></span></td>
                                <td><span class="status-badge status-<?php echo $complaint['status']; ?>"><?php echo ucfirst(str_replace('_', ' ', $complaint['status'])); ?></span></td>
                                <td><?php echo date('M d, Y', strtotime($complaint['created_at'])); ?></td>
                                <td>
                                    <button class="btn-action" data-toggle="modal" data-target="#modal<?php echo $complaint['complaint_id']; ?>">
                                        <i class="fas fa-eye"></i> View
                                    </button>
                                </td>
                            </tr>
                            
                            <!-- Modal for each complaint -->
                            <div class="modal fade" id="modal<?php echo $complaint['complaint_id']; ?>" tabindex="-1">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title"><i class="fas fa-exclamation-circle"></i> Complaint #<?php echo $complaint['complaint_id']; ?></h5>
                                            <button type="button" class="close" data-dismiss="modal" style="color: white;"><span>&times;</span></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row mb-3">
                                                <div class="col-md-6">
                                                    <p><strong>Student:</strong> <?php echo htmlspecialchars($complaint['Fname'] . ' ' . $complaint['Lname']); ?></p>
                                                    <p><strong>Roll No:</strong> <?php echo htmlspecialchars($complaint['student_id']); ?></p>
                                                    <p><strong>Contact:</strong> <?php echo htmlspecialchars($complaint['Mob_no']); ?></p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p><strong>Category:</strong> <?php echo htmlspecialchars($complaint['category']); ?></p>
                                                    <p><strong>Priority:</strong> <span class="priority-badge priority-<?php echo $complaint['priority']; ?>"><?php echo ucfirst($complaint['priority']); ?></span></p>
                                                    <p><strong>Date:</strong> <?php echo date('F d, Y h:i A', strtotime($complaint['created_at'])); ?></p>
                                                </div>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <h6><strong>Subject:</strong></h6>
                                                <p><?php echo htmlspecialchars($complaint['subject']); ?></p>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <h6><strong>Description:</strong></h6>
                                                <p style="background: #f5f5f5; padding: 15px; border-radius: 10px;"><?php echo nl2br(htmlspecialchars($complaint['description'])); ?></p>
                                            </div>
                                            
                                            <hr>
                                            
                                            <form method="POST" action="">
                                                <input type="hidden" name="complaint_id" value="<?php echo $complaint['complaint_id']; ?>">
                                                
                                                <div class="form-group">
                                                    <label><strong>Update Status:</strong></label>
                                                    <select name="status" class="form-control">
                                                        <option value="pending" <?php echo $complaint['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                                        <option value="in_progress" <?php echo $complaint['status'] == 'in_progress' ? 'selected' : ''; ?>>In Progress</option>
                                                        <option value="resolved" <?php echo $complaint['status'] == 'resolved' ? 'selected' : ''; ?>>Resolved</option>
                                                        <option value="rejected" <?php echo $complaint['status'] == 'rejected' ? 'selected' : ''; ?>>Rejected</option>
                                                    </select>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <label><strong>Response to Student:</strong></label>
                                                    <textarea name="response" class="form-control" rows="4" placeholder="Write your response here..."><?php echo htmlspecialchars($complaint['response'] ?? ''); ?></textarea>
                                                </div>
                                                
                                                <button type="submit" name="update-complaint" class="btn-action">
                                                    <i class="fas fa-save"></i> Update Complaint
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <footer style="background: #1a1a2e; padding: 30px 0; margin-top: 50px;">
        <div class="container text-center">
            <a class="navbar-brand" href="#" style="color: #00d4ff;">Hostel<span class="display"> Management</span></a>
            <p style="color: rgba(255,255,255,0.6); margin-top: 15px;">&copy; 2025 Hostel Management System. All Rights Reserved | Developed by Student Developer</p>
        </div>
    </footer>

    <script src="web_home/js/jquery-2.2.3.min.js"></script>
    <script src="web_home/js/bootstrap.js"></script>
</body>
</html>
